#pip install -e .
from .training import (
    # Main classes
    MiniTransformerConfig,
    MiniTransformerBlock,
    MiniP3GPT,
    FibrosisDataset,
    
    # Training utilities
    train_epoch,
    validate,
    validate_by_instruction,
    create_weighted_sampler,
    
    # Model saving/loading
    save_model,
    load_model,
    
    # Preprocessing
    load_data,
    prepare_datasets
)

from .tokenizer import (
    PromptStructureTokenizer,
    test_tokenizer_structure,
    test_tokenization,
    debug_print_vocab,
    load_tokenizer,
    XMLAwareTokenizer
)

from .inference import (
    complete_metadata,
    add_is_fibrosis,
    add_is_fibrosis_with_attention,
    visualize_attention_ascii,
    summarize_key_attentions,
    analyze_gene_attention
)

__all__ = [
    'MiniTransformerConfig',
    'MiniTransformerBlock',
    'MiniP3GPT',
    'FibrosisDataset',
    'train_epoch',
    'validate',
    'validate_by_instruction',
    'create_weighted_sampler',
    'save_model',
    'load_model',
    'load_data',
    'prepare_datasets',
    
    'PromptStructureTokenizer',
    'test_tokenizer_structure',
    'test_tokenization',
    'debug_print_vocab',
    'load_tokenizer',
    'XMLAwareTokenizer',

    'complete_metadata',
    'add_is_fibrosis',
    'add_is_fibrosis_with_attention',
    'visualize_attention_ascii',
    'summarize_key_attentions',
    'analyze_gene_attention'
    
]